<?php
$name = $_GET['name'] ?? 'N/A';
$department = $_GET['department'] ?? 'N/A';
$register_number = $_GET['register_number'] ?? 'N/A';
$domain = $_GET['domain'] ?? 'Digital Marketing';
$college_name = $_GET['college_name'] ?? 'N/A';
$college_address = $_GET['college_address'] ?? 'N/A';
$from_date = $_GET['from_date'] ?? '2025-05-12';
$to_date = $_GET['to_date'] ?? '2025-05-27';
$date_generated = $_GET['date'] ?? date('Y-m-d');
$gender = strtolower($_GET['gender'] ?? 'female');

// Pronouns
$pronoun = $gender === 'female' ? 'she' : 'he';
$possessive = $gender === 'female' ? 'her' : 'his';

$from = date('d-m-Y', strtotime($from_date));
$to = date('d-m-Y', strtotime($to_date));
$generated_on = date('d-m-Y', strtotime($date_generated));
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Training Certificate</title>
    <style>
        @media print {
            @page {
                size: A4 portrait;
                margin: 20mm;
            }
            .print-btn {
                display: none;
            }
        }

        body {
            font-family: 'Arial', sans-serif;
            background: #fff;
            margin: 0;
            padding: 0;
        }

        .certificate-box {
            width: 100%;
            max-width: 210mm;
            padding: 20mm;
            margin: auto;
            background: #fff;
            box-sizing: border-box;
            position: relative;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 30px;
        }

        .logo {
            width: 80px;
        }

        .company-details {
            text-align: right;
            font-size: 14px;
        }

        .title {
            text-align: center;
            font-size: 22px;
            font-weight: bold;
            text-decoration: underline;
            margin-bottom: 30px;
        }

        .content {
            font-size: 16px;
            line-height: 1.8;
            text-align: justify;
        }

        .content strong {
            font-weight: bold;
        }

        .signature-block {
            margin-top: 60px;
            display: flex;
            justify-content: space-between;
            align-items: flex-end;
        }

        .sign-box {
            width: 45%;
            text-align: left;
        }

        .sign-box p {
            margin: 0;
            font-weight: bold;
        }

        .date-box {
            width: 45%;
            text-align: right;
        }

        .footer {
            text-align: center;
            font-size: 12px;
            color: #444;
            position: absolute;
            bottom: 20px;
            width: 100%;
        }

        .print-btn {
            text-align: center;
            margin: 30px 0;
        }

        .print-btn button {
            padding: 10px 20px;
            font-size: 16px;
            background: #007bff;
            color: #fff;
            border: none;
            border-radius: 5px;
            cursor: pointer;
        }

        .print-btn button:hover {
            background-color: #0056b3;
        }
    </style>
</head>
<body>
<div class="certificate-box">
    <div class="header">
        <div class="logo">
            <img src="logo.png" alt="Logo" style="width: 100%;">
        </div>
        <div class="company-details">
            <strong>SCHOENEN DIS LLP</strong><br>
            112/1, Second floor, Sri Sai Complex,<br>
            Court Rd, Veapamood Junction, Nagercoil,<br>
            Tamil Nadu 629001<br>
            Contact: 7598400285
        </div>
    </div>

    <div class="title">TRAINING CERTIFICATE</div>

    <div class="content">
        <p>This is to certify that <strong><?php echo htmlspecialchars($name); ?></strong> with registration number <strong><?php echo htmlspecialchars($register_number); ?></strong> from the <strong><?php echo htmlspecialchars($department); ?></strong> department of <strong><?php echo htmlspecialchars($college_name); ?></strong>, situated in <?php echo htmlspecialchars($college_address); ?> has successfully completed Internship at <strong>SCHOENEN DIS LLP</strong>.</p>

        <p><strong>Training Period:</strong> <?php echo $from; ?> to <?php echo $to; ?><br>
            <strong>Internship Domain:</strong> <?php echo htmlspecialchars($domain); ?></p>

        <p>During this period, she has demonstrated dedication and commitment in understanding core aspects of Digital Marketing, including SEO, Social Media Marketing, Content Creation, and Analytics. We appreciate her enthusiasm, creativity, and proactive approach.</p>

        <p>We wish <strong><?php echo htmlspecialchars($name); ?></strong> success in her future endeavors.</p>
    </div>

    <div class="signature-block">
        <div class="sign-box">
            <p>For SCHOENEN DIS LLP</p>
            <p>Authorized Signatory</p>
        </div>
        <div class="date-box">
            <p>Date: <strong><?php echo $generated_on; ?></strong></p>
        </div>
    </div>

    <div class="footer">
        This certificate has been issued by SCHOENEN DIS LLP in recognition of successful completion of the internship program.
    </div>
</div>

<div class="print-btn">
    <button onclick="window.print()">Print Certificate</button>
</div>
</body>
</html>
