<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Database connection settings
$servername = "localhost";
$username = "bpoosspc_certi";
$password = "Admin@pass123";
$dbname = "bpoosspc_certi";

// Improved database connection with error handling
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);
try {
    $conn = new mysqli($servername, $username, $password, $dbname);
    $conn->set_charset("utf8mb4"); // Set character encoding
} catch (Exception $e) {
    die("Database Connection Failed: " . $e->getMessage());
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Retrieve and sanitize form data
    $name = trim($_POST['name']);
    $department = trim($_POST['department']);
    $register_number = trim($_POST['register_number']);
    $domain = trim($_POST['domain']);
    $college_name = trim($_POST['college_name']);
    $college_address = trim($_POST['college_address']);
    $from_date = trim($_POST['from_date']);
    $to_date = trim($_POST['to_date']);
    $date = date('Y-m-d'); // Auto-generated date

    // Validate required fields
    if (empty($name) || empty($department) || empty($register_number) || empty($domain) ||
        empty($college_name) || empty($college_address) || empty($from_date) || empty($to_date)) {
        die("All fields are required!");
    }

    // Prepare SQL statement
    $stmt = $conn->prepare("INSERT INTO internship_certificates 
        (name, department, register_number, domain, college_name, college_address, from_date, to_date, date_generated) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");

    if (!$stmt) {
        die("Prepare failed: " . $conn->error);
    }

    // Bind and execute
    $stmt->bind_param("sssssssss", $name, $department, $register_number, $domain, $college_name, $college_address, $from_date, $to_date, $date);
    
    if (!$stmt->execute()) {
        die("Execution failed: " . $stmt->error);
    }

    $stmt->close();
    $conn->close();

    // Redirect to certificate generation
    header("Location: certificate.php?" . http_build_query([
        'name' => $name,
        'department' => $department,
        'register_number' => $register_number,
        'domain' => $domain,
        'college_name' => $college_name,
        'college_address' => $college_address,
        'from_date' => $from_date,
        'to_date' => $to_date,
        'date' => $date
    ]));
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>SCHOENEN DIS LLP Certificate for Internship</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <style>
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; margin: 0; padding: 0; }
        .container { width: 50%; margin: 50px auto; padding: 20px; background: white; box-shadow: 0 0 10px rgba(0,0,0,0.1); border-radius: 5px; }
        h2 { text-align: center; margin-bottom: 20px; }
        label { font-weight: bold; display: block; margin-top: 10px; }
        input, select, textarea { width: 100%; padding: 8px; margin-top: 5px; border: 1px solid #ccc; border-radius: 4px; }
        button { width: 100%; padding: 10px; margin-top: 20px; background: #007bff; color: white; border: none; border-radius: 4px; cursor: pointer; }
        button:hover { background: #0056b3; }
        .header, .footer { text-align: center; background: #007bff; color: white; padding: 15px 0; font-size: 18px; }
        .footer { margin-top: 20px; font-size: 14px; }
    </style>
</head>
<body>
    <div class="header">SCHOENEN DIS LLP Certificate for Internship</div>
    <div class="container">
        <h2>Fill in the Details</h2>
        <form method="post" action="">
            <label>Name of the Student:</label>
            <input type="text" name="name" required>

            <label>Department:</label>
            <input type="text" name="department" required>

            <label>Register Number:</label>
            <input type="text" name="register_number" required>

            <label>Internship Domain:</label>
            <select name="domain" required>
                <option value="">-- Select Domain --</option>
                <option value="Artificial Intelligence">Artificial Intelligence</option>
                <option value="Digital Marketing">Digital Marketing</option>
                <option value="SEO Analyst">SEO Analyst</option>
                <option value="Web Designing">Web Designing</option>
                <option value="Full Stack Developer">Full Stack Developer</option>
                <option value="Python Developer">Python Developer</option>
                <option value="UI/UX Designing">UI/UX Designing</option>
                <option value="Other">Other</option>
            </select>

            <label>College Name:</label>
            <input type="text" name="college_name" required>

            <label>College Address:</label>
            <textarea name="college_address" rows="3" required></textarea>

            <label>From Date:</label>
            <input type="text" name="from_date" class="datepicker" required>

            <label>To Date:</label>
            <input type="text" name="to_date" class="datepicker" required>

            <button type="submit">Generate Certificate</button>
        </form>
    </div>
    <div class="footer">&copy; 2025 SCHOENEN DIS LLP - All Rights Reserved</div>

    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script>
        document.querySelectorAll(".datepicker").forEach(input => {
            flatpickr(input, {
                enableTime: false,
                dateFormat: "Y-m-d",
                altInput: true,
                altFormat: "F j, Y",
                allowInput: true
            });
        });
    </script>
</body>
</html>
